//
//  Certificate.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "UtilitySupport.h"
#import "KeychainItem.h"
#import "CSSMUtils.h"
#import "Key.h"


extern NSString* KEYCHAIN_BUNDLE_IDENTIFIER;


@interface Certificate : NSCachedObject {
    SecCertificateRef certificate;
    int error;
}

+ (Certificate*)certificateWithCertificateRef:(SecCertificateRef)cert;
+ (Certificate*)certificateWithData:(NSData*)data type:(CSSM_CERT_TYPE)type encoding:(CSSM_CERT_ENCODING)encoding;

- (Certificate*)initWithCertificateRef:(SecCertificateRef)cert;
- (Certificate*)initWithData:(NSData*)data type:(CSSM_CERT_TYPE)type encoding:(CSSM_CERT_ENCODING)encoding;

- (NSData*)data;
- (CSSM_CERT_TYPE)type;

// - (NSString*)description;

//- (NSString*)issuer; // figure out the CSSM_X509_NAME data structure
//- (NSString*)subject; // figure out the CSSM_X509_NAME data structure
- (KeychainItem*)keychainItem;

/*- (CertificateBundle*)exportAsBundleOfType:(CSSM_CERT_BUNDLE_TYPE)type withEncoding:(CSSM_CERT_BUNDLE_ENCODING)encoding;
- (CertificateBundle*)exportAsDefaultBundle;*/

- (CSSM_CL_HANDLE)cryptoHandle;

- (int)lastError;
- (SecCertificateRef)certificateRef;

@end
